"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const Schema_1 = __importDefault(global[Symbol.for('ioc.use')]("Adonis/Lucid/Schema"));
class default_1 extends Schema_1.default {
    constructor() {
        super(...arguments);
        this.tableName = 'personas_dependientes';
    }
    async up() {
        this.schema.createTable(this.tableName, (table) => {
            table.increments('id');
            table.integer('persona').unsigned();
            table.string('nombre');
            table.string('apellidos');
            table.string('telefono');
            table.string('correo');
            table.string('c_postal');
            table.date('f_nacimiento');
            table.string('genero');
            table.integer('pais').unsigned();
            table.timestamp('f_creacion', { useTz: true });
            table.timestamp('f_modif', { useTz: true });
        });
    }
    async down() {
        this.schema.dropTable(this.tableName);
    }
}
exports.default = default_1;
//# sourceMappingURL=1673612144152_personas_dependientes.js.map